#!/usr/bin/perl
#

use File::Find;
use File::Slurp;
use HTML::Entities;
use Digest::file qw(digest_file_hex);

$V = "LDM Builder 2.3.0";
print $V."\n";

# -----------------------------------------------------------------------------
# Create the LDM product installers for each supported language
# -----------------------------------------------------------------------------

$num_lang = 7;

@languages		=	(
					"English",
					"German",
					"German",
					"French",
					"Spanish",
					"Dutch",
					"Chinese",
					);

@product_file	= 	(
					"../../release/product-eirma_ldm.xml",
					"../../translations/product-eirma_ldm_de_utf8.xml",
					"../../translations/product-eirma_ldm_de_latin.xml",
					"../../translations/product-eirma_ldm_fr.xml",
					"../../translations/product-eirma_ldm_es.xml",
					"../../translations/product-eirma_ldm_nl.xml",
					"../../translations/product-eirma_ldm_cn.xml",
					);

@phrase_file	= 	(
					"../phrases/phrases_en.xml",
					"../../translations/phrases_de_utf8.xml",
					"../../translations/phrases_de_latin.xml",
					"../../translations/phrases_fr.xml",
					"../../translations/phrases_es.xml",
					"../../translations/phrases_nl.xml",
					"../../translations/phrases_cn.xml",
					);

@encoding		= 	(
					"ISO-8859-1",
					"UTF-8",
					"ISO-8859-1",
					"ISO-8859-1",
					"ISO-8859-1",
					"ISO-8859-1",
					"UTF-8",
					);

$title 			= "Links and Downloads Manager";
$description 	= "Manage a document and link library";
$productid 		= "eirma_ldm";
$vborgthread	= "166094";  # vb3.7 version

$script_prefix  =   "../../release/forums";

$version_file   =   "/includes/version_ldm.php";

$extras_xml     = "../../release/forums/includes/xml/ldm_extras.xml";
$extras_dir     = "../../release/extras";

# -----------------------------------------------------------------------------

# Find all files in directory tree under first param that match (case-insensitive)
# the regex in the second, and call the third param with file as argument
# Force use of / as directory separator

sub trackDir  {
	my ($dir, $regex, $subref) = @_;
	$dir =~ tr#\\#/#;
	$dir =~ s#/$##;
    my $wanted = sub { if ($File::Find::name=~/$regex/i) { $subref->($_, $File::Find::dir); } };

    find($wanted, $dir);
    return 1;
}

# -----------------------------------------------------------------------------

my $XML;
$version = "";
open  $XML , "<", "../../release/forums/includes/local_links_init.php" or die "Unable to read version";
while (<$XML>) {$version .= $_;}
close $XML;

$version =~ s/^.*'THIS_VERSION',[\ \t]*'(.*?)'.*$/\1/gs;

$codes = "";
open  $XML , "<", "../codes/codes.xml" or die "Unable to read codes";
while (<$XML>) {$codes .= $_;}
close $XML;

$codes =~ /^.*code version="(\d+.\d+.\d+)".*$/s;
$code_version = $1;

$plugins = "";
open  $XML , "<", "../plugins/plugins.xml" or die "Unable to read plugins";
while (<$XML>) {$plugins .= $_;}
close $XML;

$templates = "";
open  $XML , "<", "../templates/templates.xml" or die "Unable to read templates";
while (<$XML>) {$templates .= $_;}
close $XML;

# -----------------------------------------------------------------------------

print 'Processing version '.$version." files\n";
if ($code_version ne $version and $code_version ne '*') {
	print "*** Warning - version of init file does not match version recorded in codes.xml (".$code_version.")\n";
}

# -----------------------------------------------------------------------------

for my $k (0..$num_lang-1) {

	my $phrases = "";
	open  $XML , "<", $phrase_file[$k] or die "Unable to read phrases $phrase_file[$k]";
	while (<$XML>) {$phrases .= $_;}
	close $XML;
	$phrases =~ s/.*<language.*?>/\t<phrases>/gs;
	$phrases =~ s/<\/language>/\t<\/phrases>/gs;
	my $encode = $encoding[$k];

	$file = <<"EOF_1";
<?xml version="1.0" encoding="#encoding#"?>

<product productid="#productid#" active="1">
	<title>#title#</title>
	<description>#description#</description>
	<version>#version#</version>
	<url>http://www.vbulletin.org/forum/showthread.php?t=#vborgthread#</url>
	<versioncheckurl><![CDATA[http://www.vbulletin.org/forum/misc.php?do=checkversion&t=#vborgthread#]]></versioncheckurl>
	<dependencies>
		<dependency dependencytype="vbulletin" minversion="3.7.0" maxversion="4.0.0 alpha 1" />
	</dependencies>
#codes#
#templates#
#plugins#
#phrases#
	<options>
	</options>
	<helptopics>
	</helptopics>
	<cronentries>
	</cronentries>
	<faqentries>
	</faqentries>
</product>
EOF_1

	$file =~ s/#productid#/$productid/g;
	$file =~ s/#title#/$title/g;
	$file =~ s/#vborgthread#/$vborgthread/g;
	$file =~ s/#description#/$description/g;
	$file =~ s/#version#/$version/g;
	$file =~ s/#codes#/$codes/g;
	$file =~ s/#templates#/$templates/g;
	$file =~ s/#plugins#/$plugins/g;
	$file =~ s/#phrases#/$phrases/g;
	$file =~ s/#encoding#/$encode/g;

	open  $XML , ">", $product_file[$k] or die "Unable to create $product_file[$k]";
	print $XML $file;
	close $XML;

	print "Built ".$languages[$k]." language product loader\n";

}

# -----------------------------------------------------------------------------

# Build the version/hash code file

my %md5_hashes;

sub md5onePHP {
    my ($file, $dir) = @_;
    $dir =~ s{$script_prefix}{};
    $md5_hashes{$dir.'/'.$file} = digest_file_hex($file, "MD5");
}

trackDir( $script_prefix, qr/(php|js)$/, \&md5onePHP );

open $XML , ">", $script_prefix.$version_file or die "Unable to create $version_file";
print $XML <<"VERS_1";
<?php

define('FILE_VERSION_LDM', '$version');

\$file_version_md5 = array(
VERS_1

foreach my $md5_hash_key (sort keys %md5_hashes) {
    if ($md5_hash_key !~ m{$version_file}) {
        print $XML "\t'".$md5_hash_key."'=>'".$md5_hashes{$md5_hash_key}."',\n";
    }
}

print $XML <<"VERS_2";
);
?>
VERS_2

close $XML;

print "Built version control file $version_file\n";

# -----------------------------------------------------------------------------

# Build the 'extras' version .xml file

my @extras;

sub scanoneXML {
    my ($file) = @_;

    my $text = read_file($file);
    if ($text =~ /ldm_extra_is_loaded
             \s*\(\s*           # opening parenthesis
             (['"])(.*?)\1      # first parameter
             \s*,\s*
             (['"])(.*?)\3      # second parameter
             \s*,\s*
             (['"])(.*?)\5      # third parameter
             \s*\)              # closing parenthesis
            /sx) {
        push @extras, {
            "code"=>encode_entities($2),
            "title"=>encode_entities($4),
            "version"=>encode_entities($6)
            };
    }

}

trackDir( $extras_dir, qr/xml$/, \&scanoneXML );

    my @extradefs;
    foreach $thisextra (@extras) {
        push @extradefs, "\t<extra title='$thisextra->{'title'}' code='$thisextra->{'code'}' version='$thisextra->{'version'}' />";
    }

    my $extradefs = join("\n", sort {uc($a) cmp uc($b)} @extradefs);

	open  $XML , ">", $extras_xml or die "Unable to create $extras_xml";
	print $XML <<EOF_2;
<?xml version="1.0" encoding="ISO-8859-1"?>

<ldm_extras>
$extradefs
</ldm_extras>
EOF_2

	close $XML;

	print "Built Extras directory .xml file\n";

# -----------------------------------------------------------------------------

